# 운영체제란
운영체제(OS)는 컴퓨터 사용자와 컴퓨터 하드웨어 사이에 중계 역할을 하면서 컴퓨터의 모든 자원과 프로그램 실행을 관리하고 제어하는 **시스템 소프트웨어**이다. 컴퓨터 자원은 하드웨어 자원*, 소프트웨어 자원*, 데이터 자원*을 포함한다.  

운영체제가 하드웨어와 응용프로그램 사이의 중계 역할을 위해 시스템 콜, 인터럽트 2가지 인터페이스를 두고 있다.

운영체제는 자원에 대한 접근과 관리 권한을 오직 운영체제에만 두는, 독점 관리를 한다. 파일이 생성되고 삭제되는 과정에서 디스크의 빈 영역을 관리하고, 파일이 저장되는 위치를 결정하고, 디스크에 파일을 기록하거나 읽는 행위는 모두 운영체제에 의해 실행된다. 따라서 사용자와 응용프로그램은 [시스템 콜](https://github.com/da-in/tech-interview-study/blob/a7a8895a8beb964a43bba9247b7fb2e355a2b3d8/CS%20Deep%20Dive/Operating%20System/%EC%8B%9C%EC%8A%A4%ED%85%9C%20%EC%BD%9C(System%20Call).md)을 통해서만 커널에 접근할 수 있다. 독점 관리를 통해 사용자와 응용프로그램으로부터 자원에 대한 손상을 막고 여러 프로그램이 자원을 공유할 수 있도록 한다.  

_\*하드웨어 자원: CPU, 메모리, 키보드 등_
_\*소프트웨어 자원: 프로그램_
_\*데이터 자원: 파일, 데이터베이스 등_

<br>

## 배경
폰노이만은 컴퓨터를 하드웨어와 소프트웨어로 분리하는 내장 프로그램 컴퓨터 개념을 최초로 발표했다.  
어셈블리어와 같은 저급 언어의 등장으로 프로그램을 작성하는 데 일정한 패턴과 기능이 반복되는 것을 발견했다.  
이러한 공통 작업을 계속 반복해서 프로그램마다 구현하는 것은 비효율적이었기 때문에, 공통 작업을 하나의 프로그램으로 묶어 다른 프로그램들이 공유할 수 있도록 했다.

이러한 공통 작업은 CPU, 메모리, I/O 장치와 같은 하드웨어 자원과 상호 작용하여 일어났다.  
하드웨어를 다루는 작업은 복잡하므로, 이를 대신해주는 소프트웨어가 필요했다. 이 소프트웨어가 운영체제(OS) 개념의 시작이다.

<br>

## 목적
사용자의 편리성과 자원 활용성에 목표가 있다.

<br>

## 구성
운영체제는 도구/GUI 소프트웨어, 커널, 디바이스 드라이버들로 구성된다.

### 도구/GUI 소프트웨어
사용자가 컴퓨터를 편리하게 사용할 수 있도록 운영체제 패키지에 포함되어 제공되는 프로그램들이다.  
Windows 운영체제를 예로 들면 파일 탐색기, 작업 관리자, 제어판, 장치 관리자 등이 있다.

### 커널(Kernel)
컴파일된 바이너리 형태로 운영체제가 설치되어있는 하드 디스크의 특정 영역에 있다가 부팅 후부터 메모리에 적재되며, 운영체제가 수행하는 모든 핵심 작업을 관리한다.  
커널 코드는 구체적으로 함수의 형태로 존재하며, 응용프로그램이 함수 호출을 통해 응용프로그램 내 함수를 호출하는 것처럼 응용프로그램에서 커널에 있는 함수를 활용하기 위해 시스템 콜을 사용하면 된다.  
- 프로세스와 스레드 관리
- 메모리 관리
- 파일 생성, 삭제, 파일 입출력 등 파일 및 파일 시스템 관리
- 디바이스 드라이버를 호출하여 장치 입출력

### 디바이스 드라이버
장치를 직접 제어하는 소프트웨어다.  
마우스의 움직임과 클릭을 인지하는 마우스 드라이버, 키보드 장치로부터 사용자가 입력한 키를 알아오는 키보드 드라이버 등이 있다.

<br>

## 기능
* CPU/프로세스 관리
* 메모리 관리
* 파일 시스템 관리
* 장치 관리
* 네트워크 관리
* 보안 관리
* 기타 관리(사용자 계정, 통계, 오류 발견 및 대응, 부팅)

<br>

## 특징

### 추상화(Abstraction)

운영체제는 컴퓨터 시스템 하드웨어를 사용자가 쉽게 다룰 수 있도록 추상화한다. 이는 CPU를 프로세스, 메모리를 메모리 관리, 디스크를 파일 및 Inode와 같이 추상화된 개념으로 제공하는 것을 의미한다.

### 가상화(Virtualization)

운영체제는 작업을 수행하는 기본 방법 중 하나로 가상화를 사용한다. 이는 하드웨어 자원을 하나로 보이게 하여 여러 프로세스가 병렬적으로 실행되는 것처럼 보이도록 한다. 이러한 가상화를 통해 CPU의 효율성을 최대화하고 더 많은 프로세스를 실행할 수 있게 한다.

* **CPU의 가상화**  
  실제로는 하나의 CPU가 번갈아가면서 프로세스를 실행하며, 이는 [Context Switching](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/PCB%20&%20Context%20Switching.md)을 통해 구현한다.

* **메모리의 가상화**  
  실행 중인 각 프로세스는 가상 주소를 사용하여 동일한 주소에 메모리를 할당받아 마치 각각이 독립적으로 메모리를 사용하는 것처럼 보인다.

### 병행성 (Concurrency)
운영체제는 여러 프로세스를 동시에 실행하며, 이를 조절하여 공유 데이터에 접근 시 발생할 수 있는 문제를 해결한다. 이를 위해 [세마포어, 락](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/%EC%84%B8%EB%A7%88%ED%8F%AC%EC%96%B4(Semaphore)%20%26%20%EB%AE%A4%ED%85%8D%EC%8A%A4(Mutex).md), [쓰레드](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/%ED%94%84%EB%A1%9C%EC%84%B8%EC%8A%A4%20&%20%EC%8A%A4%EB%A0%88%EB%93%9C.md)와 같은 개념을 사용합니다.

### 영속성 (Persistence)
운영체제는 디스크에 파일을 쓰기 위한 기능을 제공하며, 데이터를 전원이 꺼져도 안전하게 저장한다.

<br>

## 정리
* 운영체제는 모든 컴퓨터 자원을 관리한다.
* 운영체제는 자원을 독점한다.
* 운영체제는 소프트웨어이다.

---

## 참고 자료
- https://jhnyang.tistory.com/16
- https://velog.io/@codemcd/%EC%9A%B4%EC%98%81%EC%B2%B4%EC%A0%9EOS-1-%EC%9A%B4%EC%98%81%EC%B2%B4%EC%A0%9E%EB%9E%80
- https://coding-factory.tistory